package fr.asip.cps3.exemple.modele.traitements.fonctionsPKCS11.sessions;

import iaik.pkcs.pkcs11.wrapper.CK_TOKEN_INFO;
import iaik.pkcs.pkcs11.wrapper.PKCS11;
import iaik.pkcs.pkcs11.wrapper.PKCS11Exception;

import org.apache.log4j.Logger;

import fr.asip.cps3.exemple.modele.exceptions.ExceptionProgrammeExemple;
import fr.asip.cps3.exemple.modele.exceptions.ExceptionTraitement;
import fr.asip.cps3.exemple.modele.resultats.Resultat;
import fr.asip.cps3.exemple.modele.traitements.util.TraitementsUtil;

/**
 * Classe de traitement : Fermeture de toutes les sessions actives d'une carte
 *
 */
public class FermerToutesLesSessions {

	/**
	 * Le loggeur
	 */
	private static Logger log = Logger.getLogger(FermerToutesLesSessions.class);
	
	/**
	 * Renvoie le rsultat de l'opration
	 * @param librairie Librairie PKCS#11  utiliser
	 * @param idSlotToken Identifiant du slot hbergant la carte
	 * @return Rsultat de l'opration
	 * @throws ExceptionTraitement 
	 */
	public static Resultat traitementP11(PKCS11 librairie, long idSlotToken) throws ExceptionTraitement {


		try {
			
			if(librairie != null) {
		
				Resultat resultat = new Resultat("Fermer toutes les sessions actives de la carte ");
		
				try {
					
					// Rcupration du libelle de la carte
					CK_TOKEN_INFO info = librairie.C_GetTokenInfo(idSlotToken);
					if(info != null)
						resultat.appendTraitement(new String(info.label).trim()+" (C_CloseAllSessions)");
					
				} catch (PKCS11Exception e) {
					
					// On ne fait rien, il ne s'agit pas de la fonction que l'on teste dans ce traitement
					
				}
				
				try {
		
					// Traitement  tester
					librairie.C_CloseAllSessions(idSlotToken);
					
				} catch (PKCS11Exception e) {
					
					log.info("Operation echouee : "+TraitementsUtil.retranscritCodeRetour(e.getErrorCode()));
					resultat.setCodeRetour(e.getErrorCode());
					
				}
		
				return resultat;
				
			} else {
				
				// Si la librairie est nulle il est impossible de raliser l'opration
				log.error("La librairie est nulle");
				throw new ExceptionTraitement(ExceptionProgrammeExemple.TYPE_TRAITEMENT_SESSIONS_FERME_TOUTES, "La librairie est nulle");
				
			}

		} catch (Throwable t) {
			
			// Si une erreur Traitement a t rencontre on lve l'exception
			if(t instanceof ExceptionTraitement)
				throw (ExceptionTraitement)t;
			
			// Si une erreur inattendue est survenue la logue et on la lve
			log.error("Une erreur inattendue est survenue : "+ExceptionProgrammeExemple.getStacktrace(t));
			throw new ExceptionTraitement(ExceptionProgrammeExemple.TYPE_TRAITEMENT_SESSIONS_FERME_TOUTES, "Une erreur inattendue est survenue");
			
		}

	}

}
